/*
   モータードライバサンプルプログラム
   Motor driver sample program

   DCモーター１つ スイッチ２つを使用
   Uses 2 DC motors and 2 Switches

   sw1を押すと『開く』 sw2を押すと『閉じる』
   Press sw1 to open.   Press sw2 to close.
*/

// モーター motor
int ma = 6;
int mb = 7;
// スイッチ switch
int sw1 = 2;  // OPEN
int sw2 = 3; // CLOSE

void setup() {
  // 出力
  pinMode(ma, OUTPUT);
  pinMode(mb, OUTPUT);
  // 入力
  pinMode(sw1, INPUT);
  pinMode(sw2, INPUT);
}

void loop() {
  //  OPEN 『←』に向かう
  if (digitalRead(sw1) == 1 && digitalRead(sw2) == 0) {
      digitalWrite(ma, 1);
      digitalWrite(mb, 0);
      delay(100);
  }
  // CLOSE 『→』に向かう
  else if (digitalRead(sw2) == 1 && digitalRead(sw1) == 0) {
      digitalWrite(ma, 0);
      digitalWrite(mb, 1);
      delay(100);
  }
  //  停止
  else {
    digitalWrite(ma, 0);
    digitalWrite(mb, 0);
  }
}
