/*
 * モータードライバのサンプルプログラム M5Stack CORE2用
 * sample program for for M5Stack CORE2
 * 
 * 電源を入れるとディスプレイにフィッシャーくんの顔が表示されます。
 * 『左ボタン』を押すとデフォルトの顔
 * 『中央ボタン』を押すと白目をキョロキョロ
 * 『右ボタン』を押すとまばたきの様な動き
 * 
 * Fisher's face is displayed when the power is turned on
 * 『LEFT BUTTON』- show defoult face
 * 『CENTER BUTTON』- eyes move
 * 『RIGHT BUTTON』- blink
 */


//  必要ライブラリのインクルード
#include <M5Core2.h>
#include "img.h"   // 画面の描画用
#include "motor.h" // モーターの動作

void setup() {
  M5.begin();//  初期化

  // === LCD初期設定　===
  lcd.init();              // LCD初期化
  lcd.setRotation(1);      // 画面向き設定
  canvas.setColorDepth(8); // カラーモード設定（書かなければ初期値は16bit）

  colorvalue01 = lcd.color565(218, 130, 93);// 肌の色
  colorvalue02 = lcd.color565(89, 84, 90);//  目の色(黒目)
  colorvalue03 = lcd.color565(255, 255, 255);// 目の色（白目）

  canvas.setTextWrap(false);  // 改行をしないように設定
  canvas.createSprite(lcd.width(), lcd.height()); // canvasサイズ
  // ======================

  //出力の設定
  pinMode(M1, OUTPUT);
  pinMode(M2, OUTPUT);
  pinMode(M3, OUTPUT);
  pinMode(M4, OUTPUT);
  //   モーターOFF
  digitalWrite(M1, LOW);
  digitalWrite(M2, LOW);
  digitalWrite(M3, LOW);
  digitalWrite(M4, LOW);

  back_img();    //  背景画像
  defoult_face();// 顔の表示
  delay(1000);
}

void loop() {
  static bool touch = false;      // 画面が触れられているの状態を変数へと格納
  TouchPoint_t pos = M5.Touch.getPressPoint();  //  座標を変数へと格納

  // Yが240以上 (ボタンのエリア)
  if (pos.y > 240) {
    // 左のボタン
    if (pos.x < 109) {
      defoult_face();
      front();
      delay(100);
      back();
    }

    // 中央のボタン
    else if (pos.x >= 109 && pos.x <= 218) {
      move_eye();
      left();
      delay(100);
      right();
    }

    // 右のボタン
    else if (pos.x > 218) {
      blink_eye();
      right();
      delay(100);
      left();
    }
    delay(300); // 遅延時間（ms）
  }
}
