/* 画面描画用に使用したライブラリ
 *  GithubのURL
 *  https://github.com/lovyan03/LovyanGFX
 */

#ifndef IMG_H
#include <M5Core2.h> // M5Stack CORE2用のライブラリ
#define LGFX_AUTODETECT // 自動認識(D-duino-32 XS, PyBadgeはパネルID読取れないため自動認識の対象から外れているそうです)
#define LGFX_USE_V1     // v1.0.0を有効に(v0からの移行期間の特別措置とのこと。書かない場合は旧v0系で動作)
#include <LovyanGFX.hpp>          // lovyanGFXのヘッダを準備
#include <LGFX_AUTODETECT.hpp>    // クラス"LGFX"を準備

static LGFX lcd;                  // LGFXのインスタンスを作成（クラスLGFXを使ってlcdコマンドでいろいろできるようにする）
static LGFX_Sprite canvas(&lcd);  // スプライトを使う場合はLGFX_Spriteのインスタンスを作成

// -- ディスプレイ用変数 --
uint16_t x = 0;
uint16_t y = 0;

//  -- ディスプレイのサイズ --
uint16_t width = 320;  //  横幅
uint16_t height = 240; //  縦幅

// -- 色用の変数 --
uint16_t colorvalue01 = 0; // 肌の色を格納する
uint16_t colorvalue02 = 0; // 黒目の色を格納する
uint16_t colorvalue03 = 0; // 白目の色を格納する


//  =========== 背景の描画 ===========
void back_img() {
  canvas.fillScreen(colorvalue01);         // 背景塗り潰し
  canvas.pushSprite(0, 0);  // メモリ内に描画したcanvasを座標を指定して表示する
}
//  ===================================

//  =========== 顔の描画 ===========
void defoult_face() {
  // 右目
  canvas.fillCircle(70, 68, 50,  colorvalue02);// 黒目
  canvas.fillCircle(85, 55, 20,  colorvalue03);// 白目
  // 左目
  canvas.fillCircle(250, 68, 50, colorvalue02);// 黒目
  canvas.fillCircle(265, 55, 20, colorvalue03);// 白目
  // 口
  canvas.pushSprite(0, 0);  // メモリ内に描画したcanvasを座標を指定して表示する
}
//  ===================================

//  =========== 動く目の描画 ===========
void move_eye() {
  int x1 = 85;
  int x2 = 265;

  // →
  for (int i = 0; i <= 10; i++) {
    // 右目
    canvas.fillCircle(70, 68, 50,  colorvalue02);// 黒目
    canvas.fillCircle(x1, 55, 20,  colorvalue03);// 白目
    // 左目
    canvas.fillCircle(250, 68, 50, colorvalue02);// 黒目
    canvas.fillCircle(x2, 55, 20, colorvalue03);// 白目
    x1 += 1;
    x2 += 1;
    canvas.pushSprite(0, 0);  // メモリ内に描画したcanvasを座標を指定して表示する
    delay(10);
  }
  delay(500);

  //  『←』へと目を移動
  for (int i = 0; i <= 25; i++) {
    // 右目
    canvas.fillCircle(70, 68, 50,  colorvalue02);// 黒目
    canvas.fillCircle(x1, 55, 20,  colorvalue03);// 白目
    // 左目
    canvas.fillCircle(250, 68, 50, colorvalue02);// 黒目
    canvas.fillCircle(x2, 55, 20, colorvalue03);// 白目
    x1 -= 2;
    x2 -= 2;
    canvas.pushSprite(0, 0);  // メモリ内に描画したcanvasを座標を指定して表示する
    delay(10);
  }
  delay(500);
  //  『→』へと目を移動
  for (int i = 0; i <= 20; i++) {
    // 右目
    canvas.fillCircle(70, 68, 50,  colorvalue02);// 黒目
    canvas.fillCircle(x1, 55, 20,  colorvalue03);// 白目
    // 左目
    canvas.fillCircle(250, 68, 50, colorvalue02);// 黒目
    canvas.fillCircle(x2, 55, 20, colorvalue03);// 白目
    x1 += 2;
    x2 += 2;
    canvas.pushSprite(0, 0);  // メモリ内に描画したcanvasを座標を指定して表示する
    delay(10);
  }
}
//  ===================================

void blink_eye() {
  for (int i = 0; i < 105; i += 15) {
    canvas.fillEllipse(70, 38, 70, i, colorvalue01);// 肌の色
    canvas.fillEllipse(250, 38, 70, i, colorvalue01);// 肌の色
    canvas.pushSprite(0, 0);  // メモリ内に描画したcanvasを座標を指定して表示する
    delay(10);
  }
  // 右目
  canvas.fillCircle(70, 68, 50,  colorvalue02);// 黒目
  canvas.fillCircle(85, 55, 20,  colorvalue03);// 白目
  // 左目
  canvas.fillCircle(250, 68, 50, colorvalue02);// 黒目
  canvas.fillCircle(265, 55, 20, colorvalue03);// 白目
  canvas.pushSprite(0, 0);  // メモリ内に描画したcanvasを座標を指定して表示する
  delay(10);

  for (int i = 0; i < 105; i += 15) {
    canvas.fillEllipse(70, 38, 70, i, colorvalue01);// 肌の色
    canvas.fillEllipse(250, 38, 70, i, colorvalue01);// 肌の色
    canvas.pushSprite(0, 0);  // メモリ内に描画したcanvasを座標を指定して表示する
    delay(10);
  }

  // 右目
  canvas.fillCircle(70, 68, 50,  colorvalue02);// 黒目
  canvas.fillCircle(85, 55, 20,  colorvalue03);// 白目
  // 左目
  canvas.fillCircle(250, 68, 50, colorvalue02);// 黒目
  canvas.fillCircle(265, 55, 20, colorvalue03);// 白目
  canvas.pushSprite(0, 0);  // メモリ内に描画したcanvasを座標を指定して表示する
  delay(500);
}

#endif
