import RPi.GPIO as GPIO                 # GPIO　のライブラリのインポート
import time                             #time をインポート

led = 23                                # LED  のピンを　23番のピンに割り当てる　


GPIO.setwarnings(False)                                         # 以前に実行したGPIOポートの状態が残っていた時に出力される警告文を抑制する
GPIO.setmode(GPIO.BCM)                                          #  ピン番号ではなく役割に記載されたGPIOの数字で指定する

GPIO.setup(led,GPIO.OUT)                # 出力

p1 = GPIO.PWM(led, 50)                  # PWM のインスタンスをつくる  50Hz
p1.start(0)                             # PWMを開始する
print("CTRL+C = STOP program")          # コンソール画面に出力

try:
    while True:
        for n in range(0,50,10):        # 0 ～　50　まで　を　10づつループする
            p1.ChangeDutyCycle(n)       # デューティサイクルの変更
            time.sleep(0.5)             # 0.5秒間停止
        else:
            GPIO.output(led,GPIO.LOW)   # OFF
except KeyboardInterrupt:                                       # 例外処理   Ctrl+c で　実行される
    GPIO.cleanup()                                              # 全てのGPIOピンを解放
