import RPi.GPIO as GPIO                 # GPIO　のライブラリのインポート
import time                             #time をインポート

led = 23                                # LED  のピンを　23番のピンに割り当てる　
sw1 = 26                                # sw1  のピンを　26番のピンに割り当てる　

br = 0                                  # br　という変数を　0　で初期化

GPIO.setwarnings(False)                                         # 以前に実行したGPIOポートの状態が残っていた時に出力される警告文を抑制する
GPIO.setmode(GPIO.BCM)                                          #  ピン番号ではなく役割に記載されたGPIOの数字で指定する


GPIO.setup(sw1,GPIO.IN, pull_up_down=GPIO.PUD_UP)               # 出力
GPIO.setup(led,GPIO.OUT)                                        # 入力

p1 = GPIO.PWM(led, 50)                                           # PWM のインスタンスをつくる  50Hz
p1.start(0)                                                      # PWMを開始する
print("CTRL+C = STOP program")                                   # コンソール画面に出力

try:
    while True:
        if GPIO.input(sw1) == 0:                        # スイッチを押したとき
            p1.ChangeDutyCycle(br)                      # デューティサイクルの変更
            time.sleep(0.2)                             # 0.2秒間停止
            br = br + 10                                # br を　＋10　する
            if br > 100:                                # br の　値が　100　よりも大きいなら
                br = 0                                  # br = 0    リセットする
        else:
            GPIO.output(led,GPIO.LOW)                   # OFF
except KeyboardInterrupt:                                       # 例外処理   Ctrl+c で　実行される
    GPIO.cleanup()                                              # 全てのGPIOピンを解放
