import RPi.GPIO as GPIO                 # GPIO　のライブラリのインポート
import time                             #time をインポート

led = 23                                # LED  のピンを　23番のピンに割り当てる　
photo1 = 26                                # photo1  のピンを　26番のピンに割り当てる　

GPIO.setwarnings(False)                                         # 以前に実行したGPIOポートの状態が残っていた時に出力される警告文を抑制する
GPIO.setmode(GPIO.BCM)                                          #  ピン番号ではなく役割に記載されたGPIOの数字で指定する

GPIO.setup(photo1,GPIO.IN, pull_up_down=GPIO.PUD_UP)               # 出力
GPIO.setup(led,GPIO.OUT)                                        # 入力

 # -- 出力  --
GPIO.output(led,GPIO.LOW)                            # OFF

print("CTRL+C = STOP program")                       # コンソール画面に出力

try:
    while True:
        if GPIO.input(photo1) == 0:                    # 明るいとき
            GPIO.output(led,GPIO.HIGH)              # ON
        else:                                       # 暗いとき
            GPIO.output(led,GPIO.LOW)               # OFF
except KeyboardInterrupt:                                       # 例外処理   Ctrl+c で　実行される
    GPIO.cleanup()                                              # 全てのGPIOピンを解放
