import RPi.GPIO as GPIO                 # GPIO　のライブラリのインポート
import time                             #time をインポート

from smbus import SMBus                 # smbus ライブラリを利用する    I2C通信
bus = SMBus(1)                          # コネクションオブジェクトを取得


GPIO.setwarnings(False)                                         # 以前に実行したGPIOポートの状態が残っていた時に出力される警告文を抑制する
GPIO.setmode(GPIO.BCM)                                          #  ピン番号ではなく役割に記載されたGPIOの数字で指定する


an0 = 0                                 # an0 という変数を　０　で　初期化する
led1 = 23                                # led  のピンを　23番のピンに割り当てる　
led2 = 22                               # led2  のピンを　22番のピンに割り当てる　
led3 = 25                               # led3  のピンを　25番のピンに割り当てる　

  
GPIO.setup(led1,GPIO.OUT)               # 出力
GPIO.setup(led2,GPIO.OUT)               # 出力
GPIO.setup(led3,GPIO.OUT)               # 出力
 # -- 出力  --
GPIO.output(led1,GPIO.LOW)              # OFF
GPIO.output(led2,GPIO.LOW)              # OFF
GPIO.output(led3,GPIO.LOW)              # OFF

def read_ain(i):
    global bus
    bus.write_byte(0x48, i)                     #  書き込む
    bus.read_byte(0x48)                         #  読み込む
    return bus.read_byte(0x48)

print("CTRL+C = STOP program")                       # コンソール画面に出力
try:
    while True:
        an0 = read_ain(0)                       # アナログの値を取得
        val = 160 - an0                         #　160 - 取得した値
        ledv = val + 70                         # val の値に　＋70を　する
        print(str(an0)+" - "+str(val))          # コンソール画面に　　　アナログの取得した値　　計算したval　の値の　出力
        print("-")
        bus.write_byte_data(0x48, 0x40, ledv)   # データを送信   write_i2c_block_data(addr, ord, vals) ---  addr はデバイスアドレス -送信データのうち最初の 1バイトを ord - 残りを vals
        if val > 20 and val < 80:               # val の値が　 30 < val < 69  ならば
            GPIO.output(led1,GPIO.HIGH)         # ON
        else:
            GPIO.output(led1,GPIO.LOW)          # OFF
        if val > 81 and val < 129:              #  val の値が　 70 < val < 110  ならば
            GPIO.output(led2,GPIO.HIGH)         # ON
        else:
            GPIO.output(led2,GPIO.LOW)          # OFF
        if val > 130:                           # val　の値が　111よりも小さければ
            GPIO.output(led3,GPIO.HIGH)         # ON
        else:
            GPIO.output(led3,GPIO.LOW)          # OFF

except KeyboardInterrupt:                                       # 例外処理   Ctrl+c で　実行される
    GPIO.cleanup()                                              # 全てのGPIOピンを解放
