import RPi.GPIO as GPIO                 # GPIO　のライブラリのインポート
import time                             #time をインポート

mota = 22                               # mota  のピンを　22番のピンに割り当てる　
motb = 23                               # motｂ  のピンを　23番のピンに割り当てる　
in26 = 26                               # in26  のピンを　26番のピンに割り当てる　
in19 = 19                               # in19  のピンを　19番のピンに割り当てる　

GPIO.setwarnings(False)                 # 以前に実行したGPIOポートの状態が残っていた時に出力される警告文を抑制する
GPIO.setmode(GPIO.BCM)                  #  ピン番号ではなく役割に記載されたGPIOの数字で指定する

GPIO.setup(mota,GPIO.OUT)                               #  出力
GPIO.setup(motb,GPIO.OUT)                               #  出力
GPIO.setup(in26,GPIO.IN, pull_up_down=GPIO.PUD_UP)      #  入力
GPIO.setup(in19,GPIO.IN, pull_up_down=GPIO.PUD_UP)      #  入力

#  --  出力  --
GPIO.output(mota,GPIO.LOW)       #  OFF
GPIO.output(motb,GPIO.LOW)       #  OFF

print("CTRL+C = STOP program")          # コンソール画面に出力

try:
    while True:
        if GPIO.input(in26) == 0:                           #  in26  を押したとき
            GPIO.output(motb,GPIO.HIGH)                     #  ON
        else:                                               #  それ以外
            GPIO.output(motb,GPIO.LOW)                      #  OFF

        if GPIO.input(in19) == 0:                           #  in19  を押したとき
            GPIO.output(mota,GPIO.HIGH)                     #  ON
        else:                                               #  それ以外
            GPIO.output(mota,GPIO.LOW)                      #  OFF

except KeyboardInterrupt:                                 #    例外処理   Ctrl+c で　実行される
    GPIO.cleanup()                                        # 　　　全てのGPIOピンを解放
