import RPi.GPIO as GPIO                 # GPIO　のライブラリのインポート
import time                             #time をインポート

mota = 22                               # mota  のピンを　22番のピンに割り当てる　
motb = 23                               # motｂ  のピンを　23番のピンに割り当てる

GPIO.setwarnings(False)                 # 以前に実行したGPIOポートの状態が残っていた時に出力される警告文を抑制する
GPIO.setmode(GPIO.BCM)                  #  ピン番号ではなく役割に記載されたGPIOの数字で指定する

GPIO.setup(mota,GPIO.OUT)               #  OUT 
GPIO.setup(motb,GPIO.OUT)               #  OUT 

p1 = GPIO.PWM(mota, 100)                # 100Hz
p2 = GPIO.PWM(motb, 50)                 # 50Hz

print("CTRL+C = STOP program")          # コンソール画面に出力

try:
    while True:
            n = 100
            p1.start(0)
            p1.ChangeDutyCycle(n)                   #　PWMのデューティー比を　　100　へ　変更
            time.sleep(1)                           # 1秒間停止
            p1.stop()                               # STOP
            GPIO.output(mota,GPIO.LOW)              # OFF
            time.sleep(2)                           # 1秒間停止

            n = 30
            p2.start(0)                             #　PWMのデューティー比を　　30　へ　変更
            p2.ChangeDutyCycle(n)
            time.sleep(1)                           # 1秒間停止
            p2.stop()                               # STOP
            GPIO.output(motb,GPIO.LOW)              # OFF
            time.sleep(2)                           # 2秒間停止

except KeyboardInterrupt:                           #  例外処理   Ctrl+c で　実行される
    GPIO.cleanup()                                  # 　全てのGPIOピンを解放
