import RPi.GPIO as GPIO                 # GPIO　のライブラリのインポート
import time                             #time をインポート

leda = 20                               # leda  のピンを　20番のピンに割り当てる　
ledb = 21                               # ledb  のピンを　21番のピンに割り当てる　
in18 = 18                               # in18  のピンを　18番のピンに割り当てる　
in19 = 19                               # in19  のピンを　19番のピンに割り当てる
irpow = 23                              # irpow のピンを　19番のピンに割り当てる

GPIO.setwarnings(False)                 # 以前に実行したGPIOポートの状態が残っていた時に出力される警告文を抑制する
GPIO.setmode(GPIO.BCM)                  #  ピン番号ではなく役割に記載されたGPIOの数字で指定する

GPIO.setup(leda,GPIO.OUT)                               # 出力
GPIO.setup(ledb,GPIO.OUT)                               # 出力
GPIO.setup(irpow,GPIO.OUT)                              # 出力
GPIO.setup(in18,GPIO.IN, pull_up_down=GPIO.PUD_UP)      # 入力
GPIO.setup(in19,GPIO.IN, pull_up_down=GPIO.PUD_UP)      # 入力
# -- 出力  --
GPIO.output(leda,GPIO.LOW)              # OFF
GPIO.output(ledb,GPIO.LOW)              # OFF
GPIO.output(irpow,GPIO.HIGH)            # ON

print("CTRL+C = STOP program")          # コンソール画面に出力

try:
    while True:
        if GPIO.input(in18) == 1:                         #    白のとき
            GPIO.output(ledb,GPIO.HIGH)                   #    ON
        else:
            GPIO.output(ledb,GPIO.LOW)                    #    OFF

        if GPIO.input(in19) == 1:                         #    黒のとき
            GPIO.output(leda,GPIO.HIGH)                   #    ON
        else:
            GPIO.output(leda,GPIO.LOW)                    #    OFF

except KeyboardInterrupt:                                       # 例外処理   Ctrl+c で　実行される
    GPIO.cleanup()                                              # 全てのGPIOピンを解放 