import RPi.GPIO as GPIO                     # GPIO　のライブラリのインポート
import time                                 #time をインポート

from smbus import SMBus                 # smbus ライブラリを利用する    I2C通信
bus = SMBus(1)                          # コネクションオブジェクトを取得

an0 = 0                                 # an0 を初期化する
an1 = 1                                 # an0 を初期化する
leda = 20                               # leda の　ピンを　20番ピン　を割り当てる
ledb = 21                               # ledb の　ピンを　21番ピン　を割り当てる
irpow = 23                              # irpow のピンを　23番のピンに割り当てる

GPIO.setwarnings(False)                 # 以前に実行したGPIOポートの状態が残っていた時に出力される警告文を抑制する
GPIO.setmode(GPIO.BCM)                  #  ピン番号ではなく役割に記載されたGPIOの数字で指定する

GPIO.setup(leda,GPIO.OUT)               # 出力
GPIO.setup(ledb,GPIO.OUT)               # 出力
GPIO.setup(irpow,GPIO.OUT)              # 出力
#  --  出力  --
GPIO.output(leda,GPIO.LOW)              # OFF
GPIO.output(ledb,GPIO.LOW)              # OFF
GPIO.output(irpow,GPIO.HIGH)            # ON

def read_ain(i):
    global bus
    bus.write_byte(0x48, i)             # 書き込む
    bus.read_byte(0x48)                 # 読み込む
    return bus.read_byte(0x48)

print("CTRL+C = STOP program")          # コンソール画面に出力

try:
    while True:
        an0 = read_ain(0)                               # アナログの値を　取得 
        an1 = read_ain(1)                               # アナログの値を　取得 

        print(str(an0)+" - "+str(an1))                 # コンソール画面に出力

        val = 60 - an0                              # 計算結果を　　val へ代入
        ledv = val + 70                             # 計算結果を    ledv へ代入
        bus.write_byte_data(0x48, 0x40, ledv)         # analog LED

        if an0 > 100:                                           # an0 の値が　100 よりも大きければ
            GPIO.output(ledb,GPIO.HIGH)                         #  ON
        else:
            GPIO.output(ledb,GPIO.LOW)                          #  OFF

        if an1 > 100:                                           # an1 の値が　100 よりも大きければ
            GPIO.output(leda,GPIO.HIGH)                         # ON
        else:
            GPIO.output(leda,GPIO.LOW)                          # OFF

except KeyboardInterrupt:                                       # 例外処理   Ctrl+c で　実行される
    GPIO.cleanup()                                              # 全てのGPIOピンを解放
