import RPi.GPIO as GPIO                     # GPIO　のライブラリのインポート
import time                                 #time をインポート

from smbus import SMBus                 # smbus ライブラリを利用する    I2C通信
bus = SMBus(1)                          # コネクションオブジェクトを取得

an0 = 0                                 # an0 を初期化する
leda = 20                               # leda の　ピンを　20番ピン　を割り当てる
in5 = 5                                 # in5  の　ピンを　　5番ピン　を割り当てる
led_pow = 22                            # irpow のピンを　22番のピンに割り当てる


GPIO.setwarnings(False)                 # 以前に実行したGPIOポートの状態が残っていた時に出力される警告文を抑制する
GPIO.setmode(GPIO.BCM)                  #  ピン番号ではなく役割に記載されたGPIOの数字で指定する

GPIO.setup(leda,GPIO.OUT)                               # 出力
GPIO.setup(led_pow,GPIO.OUT)                            # 出力
GPIO.setup(in5,GPIO.IN, pull_up_down=GPIO.PUD_UP)       # 入力

#  --- 出力  ---
GPIO.output(leda,GPIO.LOW)                  # OFF


def read_ain(i):
    global bus
    bus.write_byte(0x48, i)                 # 書き込む
    bus.read_byte(0x48)                     # 読み込む
    return bus.read_byte(0x48)



print("CTRL+C = STOP program")          # コンソール画面に出力

try:
    while True:
        an0 = read_ain(0)                               # アナログの値を　取得
        print("an0= "+str(an0))                         # コンソール画面に出力
        val = 160 - an0                                 # 計算結果を　　val へ代入
        ledv = val + 70                                 # 計算結果を    ledv へ代入

        bus.write_byte_data(0x48, 0x40, ledv)           # 書き込む

        if an0 < 30:                                   # an0  が　146　より小さければ
            GPIO.output(leda,GPIO.HIGH)                 # ON
        else:
            GPIO.output(leda,GPIO.LOW)                  #  OFF

        if GPIO.input(in5) == 0:                        # 　スイッチを押したとき
            GPIO.output(led_pow,GPIO.HIGH)              #  ON
        else:
            GPIO.output(led_pow,GPIO.LOW)               #  OFF


except KeyboardInterrupt:                                       # 例外処理   Ctrl+c で　実行される
    GPIO.cleanup()                                              # 全てのGPIOピンを解放