import RPi.GPIO as GPIO                     # GPIO　のライブラリのインポート
import time                                 #time をインポート

from smbus import SMBus                 # smbus ライブラリを利用する    I2C通信
bus = SMBus(1)                          # コネクションオブジェクトを取得

an0 = 0                                 # an0  の　ピンを　 0番ピン　を割り当てる
led1 = 23                               # led1 の　ピンを　23番ピン　を割り当てる
led2 = 22                               # led2 の　ピンを　22番ピン　を割り当てる
led3 = 25                               # led3 の　ピンを　25番ピン　を割り当てる

color_pw = 20                           # color_pw 20　で初期化する
br1 = 0                                 # br1 を  0　で初期化する
br2 = 0                                 # br2 を  0　で初期化する
br3 = 0                                 # br3 を  0　で初期化する

GPIO.setwarnings(False)                 # 以前に実行したGPIOポートの状態が残っていた時に出力される警告文を抑制する
GPIO.setmode(GPIO.BCM)                  #  ピン番号ではなく役割に記載されたGPIOの数字で指定する

GPIO.setup(led1,GPIO.OUT)               #  出力
GPIO.setup(led2,GPIO.OUT)               #  出力
GPIO.setup(led3,GPIO.OUT)               #  出力
GPIO.setup(color_pw,GPIO.OUT)           #  入力

#  ---  出力  ---
GPIO.output(led1,GPIO.LOW)              # OFF
GPIO.output(led2,GPIO.LOW)              # OFF
GPIO.output(led3,GPIO.LOW)              # OFF
GPIO.output(color_pw,GPIO.HIGH)         #  color_pw の値で出力

def read_ain(i):
    global bus
    bus.write_byte(0x48, i)             #  書き込み
    bus.read_byte(0x48)                 #  読み込む
    return bus.read_byte(0x48)

print("CTRL+C = STOP program")                              # コンソール画面に出力

try:
    while True:
        an0 = read_ain(1)                               # アナログの値を　取得
        print("an0= "+str(an0))                         # コンソール画面に出力
        val = 160 - an0                                 # 計算結果を　　val へ代入
        ledv = val + 70                                 # 計算結果を    ledv へ代入

        print(str(an0))
        print("-")

        bus.write_byte_data(0x48, 0x40, ledv)           # 書き込み

        if an0 > 156 and br1 > 3:                       # an0 が　156　より大きく、　　　　　　　　br1    が　3より大きいなら
            GPIO.output(led1,GPIO.HIGH)                 #   ON
            br1 = 0                                     #  0　にする
        else:
            GPIO.output(led1,GPIO.LOW)

        if an0 < 153 and br2 > 3:                       # an0 が　153　より大きく、　　　　　　　　br2    が　3より大きいなら
            GPIO.output(led2,GPIO.HIGH)                 #   ON
            br2 = 0                                     #  0　にする
        else:
            GPIO.output(led2,GPIO.LOW)

        if an0 == 156 and br3 > 3:                      # an0 が　153　より大きく、　　　　　　　　br3    が　3より大きいなら
            GPIO.output(led3,GPIO.HIGH)                 #   ON
            br3 =   0                                   #  0 にする
        else:
            GPIO.output(led3,GPIO.LOW)

        if an0 == 156 or an0 == 155:                    #  an0 が　156　または　　an0 が　155なら
            br3 = br3 + 1                               #  br3 を　+1
        if an0 < 153:                                   #  an0 が　153 よりも小さい　なら
            br2 = br2 + 1                               #  br2 を　+1
        if an0 > 156:                                   #  an0 が　156 よりも大きいなら
            br1 = br1 + 1                               #  br1 を　+1

except KeyboardInterrupt:                                       # 例外処理   Ctrl+c で　実行される
    GPIO.cleanup()                                              # 全てのGPIOピンを解放