import RPi.GPIO as GPIO                     # GPIO　のライブラリのインポート
import time                                 #time をインポート

from smbus import SMBus                 # smbus ライブラリを利用する    I2C通信
bus = SMBus(1)                          # コネクションオブジェクトを取得


an0 = 0                                 # an0  の　ピンを　 0番ピン　を割り当てる
led3 = 25                               # led3 の　ピンを　25番ピン　を割り当てる

color_pw = 20                           # color_pw を　20　で　初期化する

GPIO.setwarnings(False)                 # 以前に実行したGPIOポートの状態が残っていた時に出力される警告文を抑制する
GPIO.setmode(GPIO.BCM)                  #  ピン番号ではなく役割に記載されたGPIOの数字で指定する

GPIO.setup(led3,GPIO.OUT)               #  出力
GPIO.setup(color_pw,GPIO.OUT)           #  出力

#   ---   出力   ---
GPIO.output(led3,GPIO.LOW)                          #    OFF
GPIO.output(color_pw,GPIO.HIGH)                     #    ON

def read_ain(i):
    global bus
    bus.write_byte(0x48, i)                         #    書き込み
    bus.read_byte(0x48)                             #    読み込む
    return bus.read_byte(0x48)

print("CTRL+C = STOP program")                     # コンソール画面に出力

try:
    while True:
        an0 = read_ain(1)                               # アナログの値を　取得
        val = 160 - an0                                 # 計算結果を　　val へ代入
        ledv = val + 70                                 # 計算結果を    ledv へ代入

        print(str(an0))                                 # コンソール画面に出力
        print("-")
        bus.write_byte_data(0x48, 0x40, ledv)           #  書き込み

        if an0 < 150:                                   #    an0 が　150  よりも　　小さいならば
            GPIO.output(led3,GPIO.HIGH)                 #    出力
            br3 = 0                                     #    0  にする
        else:
            GPIO.output(led3,GPIO.LOW)                  #   OFF

except KeyboardInterrupt:                                       # 例外処理   Ctrl+c で　実行される
    GPIO.cleanup()                                              # 全てのGPIOピンを解放