import RPi.GPIO as GPIO                     # GPIO　のライブラリのインポート
import time                                 #time をインポート


led = 25                                    # led の　ピンを　25　で割り当てる

GPIO.setwarnings(False)                 # 以前に実行したGPIOポートの状態が残っていた時に出力される警告文を抑制する
GPIO.setmode(GPIO.BCM)                  #  ピン番号ではなく役割に記載されたGPIOの数字で指定する

GPIO_TRIGGER = 5                        #  5番ピンに割り当てる
GPIO_ECHO = 6                           #  6番ピンに割り当てる

GPIO.setup(GPIO_TRIGGER, GPIO.OUT)          # 出力
GPIO.setup(GPIO_ECHO, GPIO.IN)              # 入力
GPIO.setup(led,GPIO.OUT)                    #     出力

# ---  出力  ---
GPIO.output(led,GPIO.LOW)                   #     OFF

def distance():
    GPIO.output(GPIO_TRIGGER, HIGH)                 #  ON
    time.sleep(0.00001)                             #  スリープ
    GPIO.output(GPIO_TRIGGER, LOW)                #  OFF

    StartTime = time.time()                         #  開始時刻の取得 する
    StopTime = time.time()                          #  終了時刻の格納用

    while GPIO.input(GPIO_ECHO) == 0:               #  0  の間
        StartTime = time.time()                     #  時間の計測開始

    while GPIO.input(GPIO_ECHO) == 1:               #  1  の間
        StopTime = time.time()                      #  終了時刻を取得

    TimeElapsed = StopTime - StartTime              # 終了時刻　- 開始時刻

    distance = (TimeElapsed * 34300) / 2            #  距離の計算

    return distance

print("CTRL+C = STOP program")                      # コンソール画面に出力

if __name__ == '__main__':
    try:
        while True:
            dist = distance()                       #  関数の呼び出し
            print("Distance = %.1f cm" % dist)      #  # コンソール画面に出力
            time.sleep(0.1)
            if dist < 7:                            #  dist が　7　よりも　小さいとき
                GPIO.output(led,GPIO.HIGH)          #  ON
            else:
                GPIO.output(led,GPIO.LOW)           #  OFF

except KeyboardInterrupt:                                       # 例外処理   Ctrl+c で　実行される
    GPIO.cleanup()                                              # 全てのGPIOピンを解放