import RPi.GPIO as GPIO                     # GPIO　のライブラリのインポート
import time                                 #time をインポート


led = 25                                     # led の　ピンを　25　で割り当てる

GPIO.setwarnings(False)                      # 以前に実行したGPIOポートの状態が残っていた時に出力される警告文を抑制する
GPIO.setmode(GPIO.BCM)                       #  ピン番号ではなく役割に記載されたGPIOの数字で指定する

GPIO_TRIGGER = 5                        #  5番ピンに割り当てる
GPIO_ECHO = 6                           #  6番ピンに割り当てる

GPIO.setup(GPIO_TRIGGER, GPIO.OUT)      #  出力
GPIO.setup(GPIO_ECHO, GPIO.IN)          #  入力
GPIO.setup(led,GPIO.OUT)                #  出力

#  ---  出力  ---
GPIO.output(led,GPIO.LOW)               #   OFF

p1 = GPIO.PWM(led, 50)                  #   50Hz
p1.start(0)                             #   開始

def distance():
    GPIO.output(GPIO_TRIGGER, HIGH)                             #   ON

    time.sleep(0.00001)
    GPIO.output(GPIO_TRIGGER, LOW)                              #   OFF

    StartTime = time.time()                                     #  開始時刻の取得 する
    StopTime = time.time()                                      #  終了時刻の格納用

    while GPIO.input(GPIO_ECHO) == 0:
        StartTime = time.time()                                 #  時間の計測開始

    while GPIO.input(GPIO_ECHO) == 1:                           #  1 の　間
        StopTime = time.time()                                  #  終了時刻の取得

    TimeElapsed = StopTime - StartTime                          #  計算結果を代入
    distance = (TimeElapsed * 34300) / 2                        #  距離を求め、代入

    return distance

print("CTRL+C = STOP program")                                   # コンソール画面に出力

if __name__ == '__main__':
    try:
        while True:
            dist = distance()                                   #  関数の呼び出し
            print(("Distance = %.1f cm" % dist))                #  コンソール画面に出力
            if dist > 100:                                      #  dist 　の値が　100　よりも　大きいとき
                dist = 100                                      #  dist   の　値を　100　にする
            p1.ChangeDutyCycle(dist)                            #
            time.sleep(0.1)

except KeyboardInterrupt:                                       #  例外処理   Ctrl+c で　実行される
    GPIO.cleanup()                                              #  全てのGPIOピンを解放
