import RPi.GPIO as GPIO                     # GPIO　のライブラリのインポート
import time                                 #time をインポート

mota = 22                                   # mota の　ピンを　22　で割り当てる
motb = 23                                   # mota の　ピンを　23　で割り当てる

sig = 27                                    # sig の　ピンを　27　で割り当てる
ele_pow = 20                                # ele_pow 　のピンを　27　で割り当てる
stp = 0                                     # stp 　の値を 20  で初期化する
ids = 0                                     # ids 　の値を 20  で初期化する

GPIO.setwarnings(False)                      # 以前に実行したGPIOポートの状態が残っていた時に出力される警告文を抑制する
GPIO.setmode(GPIO.BCM)                       #  ピン番号ではなく役割に記載されたGPIOの数字で指定する

GPIO.setup(mota,GPIO.OUT)                                       #  出力
GPIO.setup(motb,GPIO.OUT)                                       #  出力
GPIO.setup(sig,GPIO.IN, pull_up_down=GPIO.PUD_UP)               #  入力
GPIO.setup(ele_pow,GPIO.OUT)                                    #  出力

#   ---  出力  ---
GPIO.output(ele_pow,GPIO.HIGH)                              #  ON

p2 = GPIO.PWM(motb, 50)                                     # 50Hz

num_steps = 74                                              # num_steps という　変数を作成
print("CTRL+C = STOP program")                              # コンソール画面に出力
p2.start(0)                                                 #  PWM 開始

try:
    while True:
        n = 20                                      #  n という　変数を作成
        p2.ChangeDutyCycle(n)                       #  デューティ比の変更
        while stp < num_steps:

            if GPIO.input(sig) == 1:                #  sig が 1  なら　
                if ids == 0:                            #  ids が　0　　なら
                    stp = stp + 1                       #  stp の値を　＋１する
                    print((stp))                        #  コンソール画面に出力

                    ids = 1                             # ids の値を　１　にする
            if GPIO.input(sig) == 0:                # sig が　0　　なら
                ids = 0                                 #  ids の値を　0 にする

        p2.ChangeDutyCycle(0)                      #  デューティ比の変更
        time.sleep(2)
        stp = 0                                    #  stp の値を　0 にする

except KeyboardInterrupt:                                       #  例外処理   Ctrl+c で　実行される
    GPIO.cleanup()                                              #  全てのGPIOピンを解放
