import cv2                          #OpneCV　というライブラリのインポート
import RPi.GPIO as GPIO             # GPIO　のライブラリのインポート

cap = cv2.VideoCapture(1)           #  オブジェクトを生成
                                    #  引数　--  0もしくは -1をデバイス番号として指定します 1やそれ以上の番号を指定することも可能
                                    #  カメラが1台なら 「0」   複数なら「1」など　　　　※うまくいかない場合は変更をしてみる
last_img = None       # 前回の画像を記憶
red = (0, 0, 255)     # 四角の外枠の色　　    BGR の並び


led = 5              # led の　ピンを　5　で割り当てる

GPIO.setwarnings(False)                  # 以前に実行したGPIOポートの状態が残っていた時に出力される警告文を抑制する
GPIO.setmode(GPIO.BCM)                   #  ピン番号ではなく役割に記載されたGPIOの数字で指定する

GPIO.setup(led,GPIO.OUT)                 #  出力

while True:
    # 画像  (フレーム)を取得
    _, frame = cap.read()
    # サイズの変更
    frame = cv2.resize(frame, (500, 300))

    # グレースケール　（白黒へ）
    gray = cv2.cvtColor(frame, cv2.COLOR_BGR2GRAY)
    gray = cv2.GaussianBlur(gray, (9, 9), 0)
    img_b = cv2.threshold(gray, 100, 255, cv2.THRESH_BINARY)[1]

    #　変化を確認
    if last_img is None:
        last_img = img_b
        GPIO.output(led,GPIO.LOW)
        continue

    frame_diff = cv2.absdiff(last_img, img_b)

    cnts = cv2.findContours(frame_diff,
            cv2.RETR_EXTERNAL,
            cv2.CHAIN_APPROX_SIMPLE)[0]

    # 変化を画面に描画 （四角の描画）
    for pt in cnts:
        x, y, w, h = cv2.boundingRect(pt)
        if w < 30:
            GPIO.output(led, GPIO.LOW)      #  OFF
            continue# 50以下を反映しない
        else:
            GPIO.output(led,GPIO.HIGH)      #  ON
        cv2.rectangle(frame, (x, y), (x+w, y+h), red, 2)

    # 上書き
    last_img = img_b

    # 画面に表示
    cv2.imshow("VIDEO", frame)
    cv2.imshow("DIFF", frame_diff)

    #  Enterキー　を押したら
    if cv2.waitKey(1) == 13: break

# キャプチャを解放する
cap.release()
cv2.destroyAllWindows()     #現在までに作られた全てのウィンドウを閉じる関数