# import
import RPi.GPIO as GPIO
import time
import tkinter  #  GUIの作成に使用

# ピンの割り当て
mota = 22
motb = 23
in6 = 5
in7 = 6

GPIO.setwarnings(False)   # 以前に実行したGPIOポートの状態が残っていた時に出力される警告文を抑制する
GPIO.setmode(GPIO.BCM)    #  ピン番号ではなく役割に記載されたGPIOの数字で指定する

#  出力に設定
GPIO.setup(mota,GPIO.OUT)
GPIO.setup(motb,GPIO.OUT)
#  入力に設定
GPIO.setup(in6,GPIO.IN, pull_up_down=GPIO.PUD_UP)
GPIO.setup(in7,GPIO.IN, pull_up_down=GPIO.PUD_UP)

#  モーター停止
GPIO.output(mota,GPIO.LOW)
GPIO.output(motb,GPIO.LOW)

# ゲート上昇の関数
def arm_up():
    while GPIO.input(in6) != 0:  # スイッチが押されるまで
        GPIO.output(mota,GPIO.HIGH)  # モーターを回転(上昇)
        print("-----------")
        time.sleep(0.1)
    GPIO.output(mota,GPIO.LOW)   # モーター停止

# ゲート下降の関数
def arm_down():
    while GPIO.input(in7) != 0:     #スイッチが押されるまで
        GPIO.output(motb,GPIO.HIGH) #モーターを回転（下降）
        print("-----------")
        time.sleep(0.1)
    GPIO.output(motb,GPIO.LOW)      #モーター停止

# GUIの作成
root = tkinter.Tk()          # ウインドウのオブジェクトを作成
root.title("PARKING SYSTEM") # タイトル作成
root.resizable(False, False) # ウインドウサイズ固定

#　キャンバスの作成
canvas = tkinter.Canvas(root, width=800, height=480)
canvas.pack()  #配置

img = tkinter.PhotoImage(file="parking.png")  # 画像を変数へと格納
canvas.create_image(400, 240, image=img)      # 画像を描画

button = tkinter.Button(root,           #　ボタンの作成
                        text="OPEN",    #　ボタンのテキスト
                        font=("Times New Roman", 20),  # フォントの指定
                        command=arm_up, # ボタンを押された時に呼ばれる関数
                        fg="black")     # カーソルをのせた時の色

button2 = tkinter.Button(root,           # ボタンの作成
                        text="CLOSE",    #　ボタンのテキスト
                        font=("Times New Roman", 20),  # フォントの指定
                        command=arm_down,# ボタンを押された時に呼ばれる関数
                        fg="black")      # カーソルをのせた時の色

button.place(x=350,y=295)  #ボタンの配置
button2.place(x=343,y=355) #ボタンの配置

# ---  メイン　---
try:
    while True:
        time.sleep(0.1)
        root.mainloop() #ウインドウを表示


except KeyboardInterrupt:
    GPIO.cleanup()  # 全てのGPIOピンを開放
