/**
 * Creating an instance of WebUSBSerial will add an additional USB interface to
 * the device that is marked as vendor-specific (rather than USB CDC-ACM) and
 * is therefore accessible to the browser.
 *
 * The URL here provides a hint to the browser about what page the user should
 * navigate to to interact with the device.
 */

//  == インクルード 必要ファイルの読み込み ==
#include <WebUSB.h>

#if USB_VERSION != 0x210  // USB2.1
#error "Bitte board 'ftDuino (WebUSB)' auswählen"
#endif

// WebUSBプロジェクトのURL
WebUSB WebUSBSerial(1 /* https:// */, "harbaum.github.io/ftduino/webusb/console");

#define Serial WebUSBSerial

const int ledPin = LED_BUILTIN;    //内部の赤色LED

void setup() {
  while (!Serial) {
    ;
  }
  Serial.begin(9600);
  // コンソール画面へ出力
  Serial.write("Sketch begins.\r\n> ");
  Serial.write("Press 'H' or 'L' for LED\r\n> ");
  Serial.flush();// データの送受信が全て完了するまで待機
  pinMode(ledPin, OUTPUT); // 内部の赤色LEDを出力へ
}

void loop() {
  // USB接続されているとき
  if (Serial && Serial.available()) {
    int byte = Serial.read();// データの読み取り
    Serial.write(byte);// 書き込み
    
    if (byte == 'H') {// H なら
      Serial.write("\r\nTurning LED on."); // コンソール画面へ出力
      digitalWrite(ledPin, HIGH);// LED点灯
      
    } else if (byte == 'L') {// L なら 
      Serial.write("\r\nTurning LED off.");// コンソール画面へ出力
      digitalWrite(ledPin, LOW);// LEDを消灯
    }
    Serial.write("\r\n> ");// 書き込み
    Serial.flush();
  }
}
