/*
  KeyboardMessage - USB-Tastatur
  Der ftDuino gibt sich als USB-Tastatur aus und "tippt" eine Nachricht, sobald
  ein Taster an Eingang I1 für mindestens 10 Millisekunden gedrückt wird.
  Basierend auf dem Sketch:
  http://www.arduino.cc/en/Tutorial/KeyboardMessage
  Dieser Beispielcode ist Public-Domain.
*/
// == インクルード 必要ファイルの読み込み ==
#include <FtduinoSimple.h>
#include <Keyboard.h>

unsigned long lastButtonEvent = 0;
uint16_t previousButtonState = Ftduino::OFF; // スイッチの状態を格納する変数

void setup() {
  // キーボードの制御を初期化
  Keyboard.begin();
}
void loop() {
  // I1に接続されたスイッチの読み取り
  uint16_t buttonState = ftduino.input_get(Ftduino::I1);
  
  // スイッチの状態が変化したら
  if(buttonState != previousButtonState) {
    lastButtonEvent = millis();// 時間を格納

    previousButtonState = buttonState; // スイッチの状態を更新
  }

 // lasutButtonEventに数値が格納されている状態 かつ
 // 10msを超えていたら
  if(lastButtonEvent && ((millis() - lastButtonEvent) > 10)) {
 
    lastButtonEvent = 0; // 時間をリセット

    if(buttonState) { // スイッチの状態をみる変数をチェックして 押されている状態なら

      // メッセージ
      Keyboard.println("Hello ftDuino!!");
    }
  }
}
