/*
  LampTimer - Lampen-Zeitschaltuhr

  (c) 2017 by Till Harbaum <till@harbaum.org>

  Turns a lamp on output O1 on for 10 seconds when a push 
  button on input I1 is being pressed.

  Schaltet eine Lampe an Ausgang O1 für 10 Sekunden ein,
  sobald ein Taster an Eingang I1 gedrückt wird.
*/

// millis()  プログラムの実行を開始した時から現在までの時間をミリ秒単位で返す
//  ==  インクルード 必要ファイルの読み込み ==
#include <FtduinoSimple.h>
uint32_t start_time_zeit = 0;  // タイマー用の変数
void setup() { 
  }

void loop() {
  if(ftduino.input_get(Ftduino::I1)) { // I1 に接続したスイッチが押されたら

    start_time_zeit = millis(); // スタートの時間を変数へ格納
    ftduino.output_set(Ftduino::O1, Ftduino::HI);  //  O1に接続したLED -- 点灯
  }
  if((start_time_zeit != 0) &&        // スタートの時間が0でない　かつ
     (millis() > start_time_zeit + 10000)) {  // 10秒以上経過したら
    start_time_zeit = 0;  // タイマー用の変数をリセット

    ftduino.output_set(Ftduino::O1, Ftduino::OFF);  //  O1に接続したLED -- OFF
  }
}
