/*
  Pwm - Pulsweitenmodulation

  (c) 2017 by Till Harbaum <till@harbaum.org>
*/

// == インクルード 必要ファイルの読み込み ==
#include <FtduinoSimple.h>
uint16_t schaltzeit = 8192;   // 8192 を変数へ格納

void setup() {
  Serial.println(9600);
}

// warte という関数の作成
void warte(uint16_t zeit) {
  while (zeit--)
    _delay_us(1000000 / 8192 / 2); // 停止 単位が マイクロ秒
}

void loop() {
  static uint8_t an_aus = false;      // LED のON　OFF　の切り替えで使用
  static uint8_t i1 = false, i2 = false; // I1,I2 に接続したスイッチの状態を保存する変数

  if (ftduino.input_get(Ftduino::I1)) { // I1のスイッチを押したら
    if (!i1 && (schaltzeit < 8192)) { // I1がTrueのとき かつ 変数schaltzeit が8192 より小さいとき
      // 長押しだと !Tureなのでスルー
      schaltzeit *= 2; // ２倍
      _delay_ms(1); // 1ms停止
    }
    i1 = true; // I1を　True にする
  } else // I1が押されていないとき
    i1 = false;  // I1をfalse

  if (ftduino.input_get(Ftduino::I2)) { // I2のスイッチを押したら
    if (!i2 && (schaltzeit > 1)) {  // I2がTrue　かつ schaltzeit が1よりも大きいとき
      // 長押しだと !Tureなのでスルー
      schaltzeit /= 2;  // 半分にする
      _delay_ms(1);  // 1ms停止
    }
    i2 = true; // I2 をTrueにする
  } else  // I2 が押されていないとき
    i2 = false;  // I2を false

  if (an_aus) // an_aus が Trueのとき
    ftduino.output_set(Ftduino::O1, Ftduino::HI); // O1に接続したLED -- ON
  else // False のとき
    ftduino.output_set(Ftduino::O1, Ftduino::OFF); //O1に接続したLED -- OFF

  warte(schaltzeit); // 関数を呼び出し
  an_aus = !an_aus;  // an_ausのTrue(またはFalse)反転
  Serial.println("====== I1 =====");
  Serial.println(i1);
}
