// StepperMotor.ino
// (c) 2018 by Till Harbaum <till@harbaum.org>

//  == インクルード 必要ファイルの読み込み ==
#include <FtduinoSimple.h>
// 200ステップ/秒-> 1回転/秒
// 400ステップ/秒-> 2回転/秒
#define STEPS_PER_SEC  400 
#define US_PER_STEP (1000000/STEPS_PER_SEC)

void setup() {
  // M1を左回転
  ftduino.motor_set(Ftduino::M1, Ftduino::LEFT);
  // M2を右回転
  ftduino.motor_set(Ftduino::M2, Ftduino::LEFT); 
}

void loop() {
  // I1に接続されたスイッチが押されたら
  while(ftduino.input_get(Ftduino::I1)) {
    // モーターを回転
    ftduino.motor_set(Ftduino::M1, Ftduino::LEFT);
    _delay_us(US_PER_STEP); // 2.5ms 停止
    ftduino.motor_set(Ftduino::M2, Ftduino::LEFT); 
    _delay_us(US_PER_STEP); // 2.5ms 停止
    ftduino.motor_set(Ftduino::M1, Ftduino::RIGHT);
    _delay_us(US_PER_STEP); // 2.5ms 停止
    ftduino.motor_set(Ftduino::M2, Ftduino::RIGHT); 
    _delay_us(US_PER_STEP); // 2.5ms 停止
  }
    
  // Taste an I2 gedrückt
  while(ftduino.input_get(Ftduino::I2)) {
    // I2に接続されたスイッチが押されたら
    ftduino.motor_set(Ftduino::M1, Ftduino::LEFT);
    _delay_us(US_PER_STEP);// 2.5ms 停止
    ftduino.motor_set(Ftduino::M2, Ftduino::RIGHT); 
    _delay_us(US_PER_STEP); // 2.5ms 停止
    ftduino.motor_set(Ftduino::M1, Ftduino::RIGHT);
    _delay_us(US_PER_STEP); // 2.5ms 停止
    ftduino.motor_set(Ftduino::M2, Ftduino::LEFT); 
    _delay_us(US_PER_STEP); // 2.5ms 停止
  }
}
