// Temperaure.ino
// Abfrage eines fischertechnik Temperatur-Widerstands an Eingang I1
// (c) 2018 by Till Harbaum <till@harbaum.org>

//  == インクルード 必要ファイルの読み込み ==
#include <Ftduino.h>
#include <math.h>          // 不動小数点の計算に使用

#define K2C 273.15         // 絶対温度 ケルビン へ
#define B 3900.0           // 温度計算で定数として使用
#define R_N 1500.0         // 25°Cの基準温度での抵抗
#define T_N (K2C + 25.0)   // ケルビンでの基準温度

float r2deg(uint16_t r) {
  if (r == 0)
    return NAN;  // 抵抗の値が　0 のとき
  //  抵抗をケルビンに変換します
  float t = T_N * B / (B + T_N * log(r / R_N));
  //  ケルビンを摂氏へ変換します
  return t - K2C;
}

void setup() {
  //  LEDを初期化
  pinMode(LED_BUILTIN, OUTPUT); // 出力
  digitalWrite(LED_BUILTIN, LOW);// 消灯
  // シリアル通信
  Serial.begin(115200);
  while (!Serial);

  ftduino.init();
  // I1に温度センサーを接続
  ftduino.input_set_mode(Ftduino::I1, Ftduino::RESISTANCE);
}

void loop() {
  uint16_t r = ftduino.input_get(Ftduino::I1); // I１からの値を取得

  // シリアルモニタへ出力
  Serial.print("I1: ");
  Serial.print(r2deg(r));  // 関数の呼び出し
  Serial.println(" °C");

  delay(1000); // 1秒停止
}
