import smbus   # i2c用のライブラリ
import time    # 時間関連のライブラリ
import RPi.GPIO as GPIO  # GPIOを使用するために使用
import random  # 数値のランダム生成に使用
import sys     # プログラムの終了・ファイルのアクセスなどに使用

GPIO.setwarnings(False) # 警告文が出ないようにする

i2c = smbus.SMBus(1)  # インスタンス化

# ftDuinoのアドレス
ft_addr = 0x40

while True:
    # ftDuinoへ送信
    send = []
    for i in range(10):
        send.append(random.randint(0,255))
    i2c.write_i2c_block_data(ft_addr, 0, send)
    #print(send)

    # ftDuinoから受信
    data = i2c.read_i2c_block_data(ft_addr,1,10)
    print(data)

    time.sleep(0.5)

    if KeyboardInterrupt:  # Ctrl + C が押されたとき
        GPIO.cleanup()  # GPIOピンを解放


sys.exit()  # プログラム終了