TYPE
  LOGLEVEL : (CRITICAL, WARNING, INFO, DEBUG) := INFO;
END_TYPE

FUNCTION_BLOCK LOGGER
  VAR_INPUT
    TRIG : BOOL;
    MSG : STRING;
    LEVEL : LOGLEVEL := INFO;
  END_VAR
  VAR
    TRIG0 : BOOL;
  END_VAR

  IF TRIG AND NOT TRIG0 THEN
  {{
   LogMessage(GetFbVar(LEVEL),(char*)GetFbVar(MSG, .body),GetFbVar(MSG, .len));
  }}
  END_IF;
  TRIG0:=TRIG;
END_FUNCTION_BLOCK


PROGRAM program0
  VAR
    Not_use_00 AT %QX0.0 : BOOL;
    CV_forward AT %QX0.1 : BOOL;
    Not_use_02 AT %QX0.2 : BOOL;
    CV_Backword AT %QX0.3 : BOOL;
    Punching_up AT %QX0.4 : BOOL;
    Punching_down AT %QX0.5 : BOOL;
    LED_red AT %QX0.6 : BOOL;
    LED_yellow AT %QX0.7 : BOOL;
    LED_green AT %QX1.0 : BOOL;
    LED_bule AT %QX1.1 : BOOL;
    PH_cv_in AT %IX0.0 : BOOL;
    PH_cv_set AT %IX0.1 : BOOL;
    LS_pm_up AT %IX0.2 : BOOL;
    LS_pm_down AT %IX0.3 : BOOL;
    Sw_led AT %IX0.4 : BOOL;
    Sw_yellow AT %IX0.5 : BOOL;
    Sw_green AT %IX0.6 : BOOL;
    Sw_bule AT %IX0.7 : BOOL;
    Sw_10 AT %IX1.0 : BOOL;
  END_VAR
  VAR
    Invert_ph_cv_in : BOOL;
    Pules_ph_cv_in : BOOL;
    Invert_ph_cv_set : BOOL;
    Pules_ph_cv_set : BOOL;
    Pules_ls_punching_up : BOOL;
    Pules_ls_punching_down : BOOL;
    Automatic_running : BOOL;
    R_TRIG1 : R_TRIG;
    R_TRIG2 : R_TRIG;
    R_TRIG3 : R_TRIG;
    R_TRIG4 : R_TRIG;
  END_VAR

  Invert_ph_cv_in := NOT(PH_cv_in);
  R_TRIG1(CLK := Invert_ph_cv_in);
  Pules_ph_cv_in := R_TRIG1.Q;
  Invert_ph_cv_set := NOT(PH_cv_set);
  R_TRIG2(CLK := Invert_ph_cv_set);
  Pules_ph_cv_set := R_TRIG2.Q;
  CV_forward := NOT(Invert_ph_cv_set) AND (CV_forward OR Invert_ph_cv_in AND Sw_led AND Automatic_running);
  Punching_down := NOT(LS_pm_down) AND (Punching_down OR Pules_ph_cv_set AND Automatic_running);
  Punching_up := NOT(LS_pm_up) AND (Punching_up OR Pules_ls_punching_down AND Automatic_running);
  CV_Backword := NOT(Invert_ph_cv_in) AND (CV_Backword OR Pules_ls_punching_up AND Automatic_running);
  R_TRIG3(CLK := LS_pm_up);
  Pules_ls_punching_up := R_TRIG3.Q;
  R_TRIG4(CLK := LS_pm_down);
  Pules_ls_punching_down := R_TRIG4.Q;
  Automatic_running := NOT(Pules_ph_cv_in) AND (Automatic_running OR Sw_led);
  LED_red := CV_forward;
  LED_yellow := Punching_down;
  LED_green := Punching_up;
  LED_bule := CV_Backword;
END_PROGRAM


CONFIGURATION Config0

  RESOURCE Res0 ON PLC
    TASK task0(INTERVAL := T#20ms,PRIORITY := 0);
    PROGRAM instance0 WITH task0 : program0;
  END_RESOURCE
END_CONFIGURATION
